/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.changes;

import filenet.vw.api.VWQueue;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigStatusListener;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRosterNode;
import filenet.vw.toolkit.admin.VWConfigStatusEvent;
import filenet.vw.toolkit.admin.VWConfigStatusTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class VWConfigChangesPane
extends JScrollPane
implements IVWConfigStatusListener {
    private VWConfigStatusTableModel m_model = null;
    private VWTable m_statusTable = null;
    private Vector m_modifiedNodes = null;

    public VWConfigChangesPane(Vector modifiedNodes) {
        this.m_modifiedNodes = modifiedNodes;
        this.m_model = new VWConfigStatusTableModel(this.m_modifiedNodes, false);
        this.m_statusTable = new VWTable(this.m_model);
        if (this.m_model.getRowCount() > 0) {
            this.m_statusTable.addRowSelectionInterval(0, 0);
        }
        this.m_statusTable.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (VWConfigChangesPane.this.m_model.getRowCount() == 0) {
                    FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        });
        this.m_statusTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_statusTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.setOpaque(true);
        this.getViewport().add(this.m_statusTable);
        VWAccessibilityHelper.setAccessibility(this.m_statusTable, this, VWResource.TableOfChanges, VWResource.TableOfChanges);
        VWAccessibilityHelper.setAccessibility(this.m_statusTable.getTableHeader(), this, VWResource.TableOfChanges, VWResource.TableOfChanges);
    }

    public void configStatusChanged(VWConfigStatusEvent evt) {
        VWConfigBaseNode baseNode = evt.getBaseNode();
        try {
            switch (evt.getType()) {
                case 2: {
                    int rowCount = this.m_model.getRowCount();
                    String service = baseNode.getServiceName();
                    int region = -1;
                    if (baseNode.getType() == 19) {
                        region = baseNode.getRegionID();
                    }
                    for (int i = rowCount - 1; i >= 0; --i) {
                        VWConfigBaseNode statusNode = this.m_model.getRowItemAt(i);
                        if (statusNode == null) continue;
                        boolean bRemove = false;
                        if (VWStringUtils.compare(service, statusNode.getServiceName()) == 0) {
                            if (region >= 0) {
                                if (region == statusNode.getRegionID()) {
                                    bRemove = true;
                                }
                            } else {
                                bRemove = true;
                            }
                        }
                        if (!bRemove) continue;
                        this.m_model.removeRow(i);
                    }
                    break;
                }
                case 15: {
                    for (int i = this.m_model.getRowCount() - 1; i >= 0; --i) {
                        VWConfigBaseNode statusNode = this.m_model.getRowItemAt(i);
                        if (statusNode == null || baseNode.getType() != statusNode.getType() || VWStringUtils.compare(baseNode.getName(), statusNode.getName()) != 0) continue;
                        this.m_model.removeRow(i);
                        this.m_model.fireTableRowsDeleted(i, i);
                    }
                    break;
                }
                default: {
                    if (!this.getStatusNode(baseNode)) {
                        baseNode.setChangeEventStatus(evt.getType());
                        this.m_model.addRow(baseNode);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int fetchCount(VWConfigBaseNode aNode) throws Exception {
        int count = 0;
        VWSession vwSession = null;
        switch (aNode.getType()) {
            case 1: 
            case 2: {
                VWConfigQueueNode qNode = (VWConfigQueueNode)aNode;
                vwSession = qNode.getSession();
                VWQueue vwQueue = vwSession.getQueue(qNode.getName());
                count = vwQueue.fetchCount();
                break;
            }
            case 3: {
                VWConfigRosterNode rNode = (VWConfigRosterNode)aNode;
                vwSession = rNode.getSession();
                VWRoster vwRoster = vwSession.getRoster(rNode.getName());
                count = vwRoster.fetchCount();
            }
        }
        return count;
    }

    public void releaseResources() {
        if (this.m_model != null) {
            this.m_model.releaseResources();
            this.m_model = null;
        }
        if (this.m_statusTable != null) {
            this.m_statusTable.removeAll();
            this.m_statusTable = null;
        }
        if (this.m_modifiedNodes != null) {
            this.m_modifiedNodes.removeAllElements();
            this.m_modifiedNodes = null;
        }
    }

    private boolean getStatusNode(VWConfigBaseNode aNode) {
        int rowCount = this.m_model.getRowCount();
        String name = aNode.getName();
        String service = aNode.getServiceName();
        int regionID = aNode.getRegionID();
        int serverID = aNode.getServerID();
        boolean bFound = false;
        for (int i = 0; i < rowCount; ++i) {
            VWConfigBaseNode statusNode = this.m_model.getRowItemAt(i);
            if (statusNode == null || VWStringUtils.compare(name, statusNode.getName()) != 0 || VWStringUtils.compare(service, statusNode.getServiceName()) != 0 || regionID != statusNode.getRegionID() || serverID != statusNode.getServerID()) continue;
            bFound = true;
        }
        return bFound;
    }
}

